
#ifndef _____PRO_FACE___MTOM_SIO_API_HEADER_FILE____
#define _____PRO_FACE___MTOM_SIO_API_HEADER_FILE____

#ifdef _MTOM_SIO_API_DLL
//	DLL Project
#define MTOM_SIO_W_EXPORT extern "C" __declspec(dllexport)
#else
//	Cliant Project
#define MTOM_SIO_W_EXPORT extern "C" __declspec(dllimport)
#endif

/////////////////////////////////////////////////////////////////
//	Result
#define	SIO_MTOM_OK					0x00000000		//	OK
#define	SIO_MTOM_ERR_PARAM			0x00000100		//	Parameter Error
#define SIO_MTOM_ERR_OPEN			0x00000101		//	Socket open error
#define SIO_MTOM_ERR_CLOSED			0x00000102		//	Socket is closed
#define SIO_MTOM_ERR_SEND			0x00000103		//	Transmit error
#define SIO_MTOM_ERR_TIMEOUT		0x00000104		//	Timeout error

#define	SIO_MTOM_ERROR				0x00000080		// Error, Detail code means unknown or result code of response
#define	SIO_MTOM_ERROR_INVALID		0x00000081		// Invalid API call or parameter
#define	SIO_MTOM_ERROR_TOUT_RES		0x00000083		// Response time-out error
#define	SIO_MTOM_ERROR_NAK			0x00000085		// NAK was Received, Detail code means NAK code

/////////////////////////////////////////////////////////////////
typedef BYTE GPCOLOR ;							// color
typedef BYTE GPLINESTYLE ;						// Line Style
typedef BYTE GPFONTSIZE ;						// Font Size
typedef BYTE GPTILE ;							// Tile Pattern
typedef BYTE GPFONT ;							// Font Pattern

/////////////////////////////////////////////////////////////////
// Parity enumeration (used by the Editor, do not change or re-order)
typedef enum
{
	PTY_NONE 	= 0,
	PTY_ODD		= 1,
	PTY_EVEN	= 2,
	PTY_MARK	= 3,
	PTY_SPACE	= 4,
} eParity;
// Stop Bits enumeration (used by the Editor, do not change or re-order)
typedef enum
{
	STB_1 		= 0,
	STB_1_5		= 1,
	STB_2		= 2,
} eStopBits;
// Flow Control enumeration (used by the Editor, do not change or re-order)
typedef enum
{
	FLW_DTR 	= 0,
	FLW_XON		= 1,
	FLW_RTS		= 2,
	FLW_NONE	= 3,
	FLW_DTRCTS	= 4,		// GP DTR/CTS flow control HACK
} eFlow;
//	configuration
//-----------Sio Config------------//
typedef struct tagMtoMPortConfig
{
	WORD	wBaudrate100 ;		//	baudrate
	BYTE	byPort ;			//	PortNo
	BYTE	byParity ;			// (eParity) Parity configuration
	BYTE	byByteSize ;		// byte size (7 or 8)
	BYTE	byStopBits ;		// (eStopBits) Number of stop bits
} MtoMPortConfig, *LPMtoMPortConfig ;
//-----------Memory Link Setting------------//
typedef struct tagMtoMSioSetting
{
	bool	bAscii ;			//	Is Ascii
	bool	bCrLf ;				//	Is CR/LF
	bool	bOneByOne ;			//	Is 1:1
	BYTE	byMachineNum ;		//	Machine Num (1:n)
	bool	b2Wire ;			//	Is 2Wire
	bool	bExtCheckSum ;		//	Check Sum
	bool	bAck ;				//	ACK
	bool	bNak ;				//	NAK
} MtoMSioSetting, *LPMtoMSioSetting ;
//-----------Memory Link SIO Config------------//
typedef struct tagMtoMSioConfig
{
	MtoMPortConfig
			stMemPortConfig ;
	MtoMSioSetting
			stMemLinkSetting ;	//	Memory Link
} MtoMSioConfig, *LPMtoMSioConfig ;

/////////////////////////////////////////////////////////////////
//	APIs
MTOM_SIO_W_EXPORT HANDLE WINAPI SIO_CreateMtoMSio(LPMtoMSioConfig pConfig);
MTOM_SIO_W_EXPORT int WINAPI SIO_OpenMtoM(HANDLE hMSio);
MTOM_SIO_W_EXPORT int WINAPI SIO_CloseMtoM(HANDLE hMSio);
MTOM_SIO_W_EXPORT int WINAPI SIO_FreeMtoMSio(HANDLE hMSio);
MTOM_SIO_W_EXPORT int WINAPI SIO_MtoMGetLastError(HANDLE hMSio);

MTOM_SIO_W_EXPORT int WINAPI SIO_MtoMESC_W(HANDLE hMSio,WORD wAddress,INT iDataCount,WORD* pwData)	;
MTOM_SIO_W_EXPORT int WINAPI SIO_MtoMESC_R(HANDLE hMSio,WORD wAddress,INT iDataCount,WORD* pwoData)	;
MTOM_SIO_W_EXPORT int WINAPI SIO_MtoMESC_T(HANDLE hMSio,GPCOLOR cDisplayColor,GPCOLOR cBackColor, INT iX1,INT iY1,GPFONTSIZE cFontSize,CHAR* szString)	;
MTOM_SIO_W_EXPORT int WINAPI SIO_MtoMESC_L(HANDLE hMSio,GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPLINESTYLE cLineStyle,INT iX1,INT iY1,INT iX2,INT iY2);
MTOM_SIO_W_EXPORT int WINAPI SIO_MtoMESC_B(HANDLE hMSio,GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPLINESTYLE cLineStyle,INT iX1,INT iY1,INT iX2,INT iY2);
MTOM_SIO_W_EXPORT int WINAPI SIO_MtoMESC_S(HANDLE hMSio,GPCOLOR cDisplayColor,GPCOLOR cBackColor,INT iX1,INT iY1,INT iX2,INT iY2,GPTILE cTile);
MTOM_SIO_W_EXPORT int WINAPI SIO_MtoMESC_C(HANDLE hMSio,GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPLINESTYLE cLineStyle,INT iX1,INT iY1,INT iRadius);
MTOM_SIO_W_EXPORT int WINAPI SIO_MtoMESC_A(HANDLE hMSio,GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPLINESTYLE cLineStyle,INT iX1,INT iY1,INT iRadius,INT iStartAngle,INT iEndAngle);
MTOM_SIO_W_EXPORT int WINAPI SIO_MtoMESC_G(HANDLE hMSio,GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPLINESTYLE cLineStyle,INT iX1,INT iY1,INT iRadius,INT iStartAngle,INT iEndAngle);
MTOM_SIO_W_EXPORT int WINAPI SIO_MtoMESC_I(HANDLE hMSio,BOOL* pbHave,DWORD *pdwCode);
MTOM_SIO_W_EXPORT int WINAPI SIO_MtoMESC_t(HANDLE hMSio,GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPFONT cFont,INT iTurn,INT iDirection,INT iHalfcentering,INT iEmphasis,GPCOLOR cSculptrue,INT iX1,INT iY1,GPFONTSIZE cFontSize,CHAR* szString);
MTOM_SIO_W_EXPORT int WINAPI SIO_MtoMESC_l(HANDLE hMSio,GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPLINESTYLE cLineStyle,INT iArrowPattern,INT iArrowDirection,INT iX1,INT iY1,INT iX2,INT iY2);
MTOM_SIO_W_EXPORT int WINAPI SIO_MtoMESC_b(HANDLE hMSio,GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPLINESTYLE cLineStyle,INT iCornerDirection,INT iCornerRadius,INT iX1,INT iY1,INT iX2,INT iY2);
MTOM_SIO_W_EXPORT int WINAPI SIO_MtoMESC_s(HANDLE hMSio,GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPTILE cTile,INT iCornerDirection,INT iCornerRadius,INT iX1,INT iY1,INT iX2,INT iY2);
MTOM_SIO_W_EXPORT int WINAPI SIO_MtoMESC_c(HANDLE hMSio,GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPTILE cTile,INT iX1,INT iY1,INT iRadius);
MTOM_SIO_W_EXPORT int WINAPI SIO_MtoMESC_g(HANDLE hMSio,GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPLINESTYLE cLineStyle,INT iX1,INT iY1,INT iRadius,INT iStartAngle,INT iEndAngle);
MTOM_SIO_W_EXPORT int WINAPI SIO_MtoMESC_SetContrast(HANDLE hMSio,DWORD dwContrast,DWORD dwLight) ;
MTOM_SIO_W_EXPORT int WINAPI SIO_MtoMESC_GetContrast(HANDLE hMSio,DWORD *dwContrast,DWORD *dwLight) ;
MTOM_SIO_W_EXPORT int WINAPI SIO_MtoMESC_Y(HANDLE hMSio,GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPLINESTYLE cLineStyle,INT iPosCount,INT* piX,INT* piY);
MTOM_SIO_W_EXPORT int WINAPI SIO_MtoMESC_y(HANDLE hMSio,GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPTILE cTile,INT iPosCount,INT* piX,INT* piY);
MTOM_SIO_W_EXPORT int WINAPI SIO_MtoMESC_M(HANDLE hMSio,GPCOLOR cDisplayColor,GPCOLOR cBackColor,BYTE bFontType,WORD wLanguage,BYTE bPriority,WCHAR* szString);
MTOM_SIO_W_EXPORT int WINAPI SIO_MtoMESC_m(HANDLE hMSio);
#endif //	_____PRO_FACE___MTOM_SIO_API_HEADER_FILE____
